#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

/**
 * Use one (float) texture to lookup the sampling point of another (normal) texture.
 * This is useful to warp-move a picture into another one. This version of the shader
 * is not general purpose, though, it uses the blue colour as alpha
 */

uniform sampler2D sourceTexture; // Camera grayscale texture
uniform sampler2D lookupTexture; // Lookup mapping with alpha in blue

smooth in vec2 texCoord;

out vec4 fragOut;

void main() {
    // Find out where in the sourceTexture to sample from
    vec2 texSize = textureSize(lookupTexture, 0);
    vec2 texUnit = 1.0 / texSize;
    vec2 reScaler = (texSize - vec2(1,1)) / texSize; // Make the grid 1 smaller

    vec3 centerLookup = texture(lookupTexture, texCoord*reScaler+0.5*texUnit).rgb;

    if(centerLookup.b == 1) {
        float gray = texture(sourceTexture, centerLookup.rg).r;
        fragOut = vec4(gray, gray, gray, centerLookup.b);
    } else {
        fragOut = vec4(0,0,0,0);
    }
}