#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

/**
 * Use one (float) texture to lookup the sampling point of another (normal) texture.
 * This is useful to warp-move a picture into another one.
 */

uniform float minX;
uniform float minY;
uniform float maxX;
uniform float maxY;

uniform int width;
uniform int height;

smooth in vec2 texCoord;

out vec4 fragOut;

void main() {
    if(texCoord.x >= minX && texCoord.x <= maxX && texCoord.y >= minY && texCoord.y <= maxY) {
        vec2 texSize = vec2(width, height);
        vec2 texUnit = 1.0 / texSize;

        vec2 range = vec2(maxX - minX, maxY - minY);
        vec2 min = vec2(minX, minY);

        vec2 pixel = floor(texCoord * texSize) - floor(min*texSize);

        fragOut = vec4(pixel / (floor(range*texSize)-1.0), 0, 1);
    } else {
        fragOut = vec4(0,0,1,1);
    }
}