#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

/**
 * Use one (float) texture to lookup the sampling point of another (normal) texture.
 * This is useful to warp-move a picture into another one.
 */

uniform sampler2D lookupTexture;

smooth in vec2 texCoord;

out vec4 fragOut;

void main() {
    float alpha = 1.0 - texture(lookupTexture, texCoord).b;

    fragOut = vec4(0,0,0,alpha);
}