#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

//From vertex shader
smooth in vec2 texCoord;

//From application
uniform sampler2D texture;

uniform int width;
uniform int height;

out vec4 outColor;

float getY() {
    vec2 size = textureSize(texture, 0);

    vec2 pixelUV = texCoord * vec2(width, height);

    int pixel = int(pixelUV.x);
    int line = int(pixelUV.y);

    float lineHeight = 1.0 / size.y;

    float y = 0;
    float y2 = 0;

    if(mod(pixel,2) == 0) {
        y = texture2D(texture, texCoord).g;
        if(mod(line,2) == 0) {
            vec2 deinterlaceUV = texCoord.xy;
            deinterlaceUV.y += lineHeight;
            y2 = texture2D(texture, deinterlaceUV.xy).g;
        }
        else {
            vec2 deinterlaceUV = texCoord.xy;
            deinterlaceUV.y -= lineHeight;
            y2 = texture2D(texture, deinterlaceUV.xy).g;
        }
    }
    else {
        y = texture2D(texture, texCoord).a;
        if(mod(line,2) == 0) {
            vec2 deinterlaceUV = texCoord.xy;
            deinterlaceUV.y += lineHeight;
            y2 = texture2D(texture, deinterlaceUV.xy).a;
        }
        else {
            vec2 deinterlaceUV = texCoord.xy;
            deinterlaceUV.y -= lineHeight;
            y2 = texture2D(texture, deinterlaceUV.xy).a;
        }
    }

    return (y + y2) * 0.5;
}

void main() {
    vec4 color;

    vec3 yuv = vec3(getY(),texture2D(texture, texCoord).rb);

    float yValue = yuv.x * 255.0;
    float uValue = yuv.y * 255.0;
    float vValue = yuv.z * 255.0;

    color.r = clamp(1.164*(yValue-16.0)+1.596*(vValue-128.0), 0, 255);
    color.g = clamp(1.164*(yValue-16.0)-0.813*(vValue-128.0)-0.391*(uValue-128.0), 0, 255);
    color.b = clamp(1.164*(yValue-16.0)+2.018*(uValue-128.0), 0, 255);
    color.a = 255;

    color /= 255;

    outColor = vec4(color);
}
