#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

uniform sampler2D sourceTexture; //Image from source

smooth in vec2 texCoord;

out vec4 fragColor;

void main() {
    vec3 sourceColor = texture(sourceTexture, texCoord).rgb;

    float minCol = 1;
    float maxCol = 0;
    for (float yOffset = max(0, texCoord.y-0.1); yOffset<=min(1,texCoord.y+0.1); yOffset+=0.01){
        for (float xOffset = max(0, texCoord.x-0.1); xOffset<=min(1,texCoord.x+0.1); xOffset+=0.01){
            vec3 testColor = texture(sourceTexture, texCoord+vec2(xOffset,yOffset)).rgb;
            if (testColor.r > maxCol) maxCol = testColor.r;
            if (testColor.r < minCol) minCol = testColor.r;
        }
    }

    vec2 limit = vec2(minCol, maxCol); 

    float sourceGray = dot(sourceColor, vec3(0.3333,0.3333,0.3333));
    sourceGray -= limit.r;
    sourceGray = clamp(sourceGray / (limit.g - limit.r), 0.0, 1.0);

    if (sourceGray>0.047){
        fragColor = vec4(sourceGray);
    } else {
        fragColor = vec4(0,0,0,0);
        return;
    }
}