#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

uniform sampler2D sourceTexture; //Image from source
uniform sampler2D limitTexture; //Grayscale limits, r is blacklevel, g is whitelevel

smooth in vec2 texCoord;
smooth in vec2 texCoordNonFlipped;

out vec4 fragColor;

void main()
{
    vec3 sourceColor = texture(sourceTexture, texCoord).rgb;
    vec2 limit = texture(limitTexture, texCoordNonFlipped).rg;

    float sourceGray = dot(sourceColor, vec3(0.3333,0.3333,0.3333));

    if(sourceGray < limit.r) {
        limit.r = sourceGray;
    }

    if(sourceGray > limit.g) {
        limit.g = sourceGray;
    }

    fragColor = vec4(limit, 0, 0);
}