#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

uniform sampler2D sourceTexture; //Image from source
uniform sampler2D limitTexture; //Grayscale limits, r is blacklevel, g is whitelevel

const float CUTOFF = 10.0/255.0;

smooth in vec2 texCoord;

out vec4 outColor;

void main()
{
    vec2 limit = texture(limitTexture, texCoord).rg;
    float diff = limit.g - limit.r;

    if(diff < CUTOFF){
        outColor = vec4(0,0,0,0);
        return;
    }

    vec3 sourceColor = texture(sourceTexture, texCoord).rgb;
    float sourceGray = dot(sourceColor, vec3(0.3333,0.3333,0.3333));

    sourceGray -= limit.r;
    sourceGray = clamp(sourceGray / diff, 0.0, 1.0);
    outColor = vec4(sourceGray,sourceGray,sourceGray,1.0);
}