#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

uniform sampler2D tex;

uniform float bellWidth;
uniform float bellHeight;
uniform float bellCenter;

smooth in vec2 texCoord;

out vec4 outColor;

float gauss(float x) {
    float a = bellHeight; //Height of curve
    float b = bellCenter; //Center of curve
    float c = bellWidth; //Width of curve

    float exponent = -(pow((x - b), 2) / (2 * pow(c, 2)));
    
    return a * exp(exponent);
}

void main() {
    float gray = texture(tex, texCoord).r;

    float gauss = gauss(1.0 - gray);

    outColor = vec4(gauss, gauss, gauss, 1);
}
