#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

uniform sampler2D texture1;
uniform sampler2D texture1Depth;
uniform sampler2D texture2;
uniform sampler2D texture2Depth;

smooth in vec2 texCoord;

out vec4 outColor;

vec2 encodeDepth(float v) {
    vec2 kEncodeMul = vec2(1.0, 255.0);
    float kEncodeBit = 1.0/255.0;
    vec2 enc = kEncodeMul * v;
    enc = fract (enc);
    enc.x -= enc.y * kEncodeBit;
    return enc;
}

float decodeDepth(vec2 v) {
    vec2 decodeMul = vec2(1.0, 1.0/255.0);
    return dot(v, decodeMul);
}

void main() {

    vec2 depthVec1 = texture2D(texture1Depth, texCoord).rg;
    vec2 depthVec2 = texture2D(texture2Depth, texCoord).rg;

    float depth1 = decodeDepth(depthVec1);
    float depth2 = decodeDepth(depthVec2);

    if(depth1 <= depth2) {
        outColor = texture(texture1, texCoord);
    } else {
        outColor = texture(texture2, texCoord);
    }
}