#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

uniform sampler2D fgTex;
uniform sampler2D bgTex;
uniform sampler2D maskTex;
uniform sampler2D fgDepthTex;
uniform sampler2D bgDepthTex;
uniform sampler2D fgTexNonCorrected;

uniform float bgNearplane;
uniform float bgFarplane;
uniform float fgNearplane;
uniform float fgFarplane;

uniform bool bgIsStatic;
uniform bool fgIsStatic;

uniform float shadowRecovery;
uniform float shadowBias;

smooth in vec2 texCoord;

out vec4 outColor;

void main() {
    //Get the depth of the forground and background
    float fgDepth = texture(fgDepthTex, texCoord).b; // cam
    float bgDepth = texture(bgDepthTex, texCoord).b; // unity

    if(!fgIsStatic) {
        fgDepth = fgDepth * (fgFarplane - fgNearplane) + fgNearplane;
    }
    
    if(!bgIsStatic) {
        bgDepth = bgDepth * (bgFarplane - bgNearplane) + bgNearplane;
    }

    //Retrieve foreground and background colors
    vec4 fg = texture(fgTex, texCoord);
    vec4 bg = texture(bgTex, texCoord);
    
    //Get the mask
    float mask = texture(maskTex, texCoord).r;

    //Presume that foreground is foreground
    float fgGray = dot(fg.rgb, vec3(1.0/3.0));
    float fgColourFalloff = 0.1; // Foreground loses colour if this far away from full white mask
    float fgColourFactor = clamp(1.0-((1.0/fgColourFalloff)*(1.0-mask)), 0.0, 1.0); // Find out how much colour to use right now
    vec4 fgCorrected = (fgColourFactor*fg) + (1.0-fgColourFactor)*fgGray;
    outColor = fgCorrected * mask + bg * (1.0 - mask);

    // Allow some of the foreground shadows/highlights to recover into the background    
    vec3 fgNonCorrected = texture(fgTexNonCorrected, texCoord).rgb;
    float fgGrayNonCorrected = dot(fgNonCorrected, vec3(1.0/3.0));

    outColor += (1.0 - mask) * shadowRecovery * (fgGrayNonCorrected - shadowBias) * 2.0;

    //If depth testing is enabled, check if background is in fact in front
    if(fgDepth > bgDepth) {
        // Fetch the background colour instead
        outColor = bg;
    }
}
