#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

uniform sampler2D tex;

uniform float targetHue;
uniform float targetChroma;
uniform float targetLightness;
uniform float hueWidth;
uniform float chromaWidth;
uniform float lightnessWidth;

uniform float amplify;

uniform float thresholdLevel;

smooth in vec2 texCoord;

out vec4 outColor;

const float pi = 3.1415926535;
const float degreesToRadians = pi / 180;

/*
 * Calculate HCL value of rgb (HueChromaLightness)
 */
vec3 calculateHCL(vec3 rgb) {
    //Find the maximum rgb component
    float M = max(rgb.r, rgb.g);
    M = max(M, rgb.b);

    //Find the minimum rgb component
    float m = min(rgb.r, rgb.g);
    m = min(m, rgb.b);

    //Calculate chroma
    float C = M - m;

    //Calculate hue
    float H;

    if(abs(C) < 0.00001) {
        H = 0;
    } else if(M == rgb.r) {
        H = mod((rgb.g - rgb.b) / C, 6);
    } else if(M == rgb.g) {
        H = (rgb.b - rgb.r) / C + 2;
    } else if(M == rgb.b) {
        H = (rgb.r - rgb.g) / C + 4;
    }

    H *= 60.0;

    float L = (M + m) * 0.5;

    return vec3(H, C, L);
}

vec2 rotateVector(vec2 v, float angleDegrees) {
    float angleRadians = angleDegrees * degreesToRadians;

    float s = sin(angleRadians);
    float c = cos(angleRadians);

    vec2 r;
    r.x = c * v.x - s * v.y;
    r.y = s * v.x + c * v.y;

    return r;
}

float gauss(float x) {
    float a = 1.0; //Height of curve
    float b = 0.0; //Center of curve
    float c = 0.2; //Width of curve

    float exponent = -(pow((x - b), 2) / (2 * pow(c, 2)));
    
    return a * exp(exponent);
}

//CHL
float weightedDistance(vec3 v1, vec3 v2) {
    float chromaDiff = (v1.x - v2.x) * chromaWidth;
    float hueDiff = ((v1.y - v2.y) * hueWidth);
    float lightnessDiff = (v1.z - v2.z) * lightnessWidth;

    return sqrt(pow(chromaDiff,2) + pow(hueDiff,2) + pow(lightnessDiff, 2));
}

void main() {
    vec4 texColor = texture(tex, texCoord);

    vec3 texHCL = calculateHCL(texColor.rgb);
    
    //vec3 currentColorVec = vec3(rotateVector(vec2(texHCL.y, 0), texHCL.x), texHCL.z);
    //vec3 targetColorVec = vec3(rotateVector(vec2(targetChroma, 0), targetHue), targetLightness);

    vec3 currentColorVec = vec3(texHCL.y, texHCL.x, texHCL.z);
    vec3 targetColorVec = vec3(targetChroma, targetHue, targetLightness);

    //float distance = distance(currentColorVec, targetColorVec);

    float distance = weightedDistance(currentColorVec, targetColorVec);

    float gauss = 1.0 - gauss(distance);

    float opacity = gauss;

    if(thresholdLevel > 0.0000001) {
        opacity = clamp((gauss - thresholdLevel) / (1.0 - thresholdLevel), 0, 1);
    }

    opacity = opacity * amplify;

    outColor = vec4(opacity, 0, 0, 1);
}
