#version 150

/**
 * © Janus Bager Kristensen & Rolf Bagge, CAVI Aarhus University, 2014
 */

/**
 * Find center of blobs with a value higher than threshold
 * Output: a single pixel group x,y coordinate to the center of mass (float) center
 * at the brightest pixel (int) "center" of each blob.
 * The center of mass and the brightest pixel will typically be quite close.
 */

uniform sampler2D texture;

const float divider = pow(2.0 * %SEARCH_AREA% + 1.0, 2.0);

smooth in vec2 texCoord;

out vec4 outColor;

void main() {
    // Set up some variables to be used locally
    vec4 texColor = texture2D(texture, texCoord);
    float circleLikeliness = texColor.r;
    float edgeDiff = texColor.b;
   
    // Check if we need to do anything or if we can simply skip this pixel entirely'
    // Filter with edge and center difference since they show the non existence of a tag
    if(circleLikeliness <= %CIRCLE_LIKELINESS_THRESHOLD% || edgeDiff >= %FALSE_POSITIVE_FILTER_THRESHOLD%) {
        outColor = vec4(0.0,0.0,0.0,0.0);
        return;
    } else {
        vec2 pixelSize = 1.0 / textureSize(texture, 0);
        vec2 position = vec2(0.0,0.0);
        float totalSum = 0;

        for (int y = -%SEARCH_AREA%; y <= %SEARCH_AREA%; y++){
            for (int x = -%SEARCH_AREA%; x <= %SEARCH_AREA%; x++){
                vec2 testPosition = texCoord+vec2(x,y)*pixelSize;
                float testColour = max(0,texture2D(texture, testPosition).r);

                if(testColour > circleLikeliness) {
                    outColor = vec4(0.0,0.0,0.0,0.0);
                    return;
                }

                position += testPosition * testColour;
                totalSum += testColour;
            }
        }

        position /= totalSum;
        totalSum /= divider;

        outColor = vec4(position,totalSum, texColor.a);
    }
}