/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.utility;

import com.illposed.osc.OSCBundle;
import com.illposed.osc.OSCListener;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPacket;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class OSCPacketDispatcher {
    private Map<String, OSCListener> addressToListener = new HashMap<String, OSCListener>();

    public void addListener(String address, OSCListener listener) {
        this.addressToListener.put(address, listener);
    }

    public void dispatchPacket(OSCPacket packet) {
        if (packet instanceof OSCBundle) {
            this.dispatchBundle((OSCBundle)packet);
        } else {
            this.dispatchMessage((OSCMessage)packet);
        }
    }

    public void dispatchPacket(OSCPacket packet, Date timestamp) {
        if (packet instanceof OSCBundle) {
            this.dispatchBundle((OSCBundle)packet);
        } else {
            this.dispatchMessage((OSCMessage)packet, timestamp);
        }
    }

    private void dispatchBundle(OSCBundle bundle) {
        OSCPacket[] packets;
        Date timestamp = bundle.getTimestamp();
        for (OSCPacket packet : packets = bundle.getPackets()) {
            this.dispatchPacket(packet, timestamp);
        }
    }

    private void dispatchMessage(OSCMessage message) {
        this.dispatchMessage(message, null);
    }

    private void dispatchMessage(OSCMessage message, Date time) {
        for (Map.Entry<String, OSCListener> addrList : this.addressToListener.entrySet()) {
            if (!message.getAddress().matches(addrList.getKey())) continue;
            addrList.getValue().acceptMessage(time, message);
        }
    }
}

