/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.OSCPacket;
import com.illposed.osc.utility.OSCJavaToByteArrayConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSCMessage
extends OSCPacket {
    private String address;
    private List<Object> arguments;

    public OSCMessage() {
        this.arguments = new LinkedList<Object>();
    }

    public OSCMessage(String address) {
        this(address, (Collection<Object>)null);
    }

    public OSCMessage(String address, Object[] arguments) {
        this.address = address;
        if (arguments == null) {
            this.arguments = new LinkedList<Object>();
        } else {
            this.arguments = new ArrayList<Object>(arguments.length);
            this.arguments.addAll(Arrays.asList(arguments));
        }
        this.init();
    }

    public OSCMessage(String address, Collection<Object> arguments) {
        this.address = address;
        this.arguments = arguments == null ? new LinkedList<Object>() : new ArrayList<Object>(arguments);
        this.init();
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void addArgument(Object argument) {
        this.arguments.add(argument);
    }

    public Object[] getArguments() {
        return this.arguments.toArray();
    }

    protected void computeAddressByteArray(OSCJavaToByteArrayConverter stream) {
        stream.write(this.address);
    }

    protected void computeArgumentsByteArray(OSCJavaToByteArrayConverter stream) {
        stream.write(',');
        if (null == this.arguments) {
            return;
        }
        stream.writeTypes(this.arguments);
        for (Object argument : this.arguments) {
            stream.write(argument);
        }
    }

    @Override
    protected byte[] computeByteArray(OSCJavaToByteArrayConverter stream) {
        this.computeAddressByteArray(stream);
        this.computeArgumentsByteArray(stream);
        return stream.toByteArray();
    }
}

